/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn;

import OreSpawn.OreSpawnMain;
import OreSpawn.OreSpawnTrees;
import dangerzone.Chunk;
import dangerzone.Fastmath;
import dangerzone.Ores;
import dangerzone.World;
import dangerzone.biomes.Biome;
import dangerzone.biomes.Trees;
import dangerzone.blocks.Blocks;

public class UtopiaBiome
extends Biome {
    Trees tr = new Trees();
    OreSpawnTrees otr = new OreSpawnTrees();
    int recently_added = 100;

    public UtopiaBiome(String s) {
        super(s);
    }

    public void generateheightmaps(World w, int d, Chunk c, int cx, int cz, int[][] dirtheight, int[][] stoneheight, int[][] baseheight) {
        int k;
        float[][] noise = new float[16][16];
        float[][] noise2 = new float[16][16];
        int dirtamp = 2;
        int dx = (cx << 4) + (int)(w.worldseed & 0xFFFFL);
        int dz = (cz << 4) + (int)(w.worldseed >> 16 & 0xFFFFL);
        int waterlevel = 60;
        int i = 0;
        while (i < 16) {
            k = 0;
            while (k < 16) {
                noise[i][k] = 1.0f;
                noise2[i][k] = (float)Fastmath.sin((double)((double)(dx + i) / 188.0 % Math.PI)) * 2.0f;
                float[] fArray = noise2[i];
                int n = k;
                fArray[n] = fArray[n] * ((float)Fastmath.sin((double)((double)(dz + k) / 137.0 % Math.PI)) * 2.0f);
                float[] fArray2 = noise2[i];
                int n2 = k;
                fArray2[n2] = fArray2[n2] * ((float)Fastmath.sin((double)((double)(dx + i) / 100.0 % Math.PI)) * 2.0f);
                float[] fArray3 = noise2[i];
                int n3 = k;
                fArray3[n3] = fArray3[n3] * ((float)Fastmath.sin((double)((double)(dz + k) / 61.0 % Math.PI)) * 2.0f);
                ++k;
            }
            ++i;
        }
        int j = 1;
        while (j < 4) {
            i = 0;
            while (i < 16) {
                k = 0;
                while (k < 16) {
                    float[] fArray = noise[i];
                    int n = k;
                    fArray[n] = fArray[n] + (float)Fastmath.sin((double)Math.toRadians((double)(dx + i) / (11.0 / (double)j)));
                    float[] fArray4 = noise[i];
                    int n4 = k;
                    fArray4[n4] = fArray4[n4] + (float)Fastmath.sin((double)Math.toRadians((double)(dz + k) / (9.0 / (double)j)));
                    float[] fArray5 = noise[i];
                    int n5 = k;
                    fArray5[n5] = fArray5[n5] * (float)Fastmath.sin((double)Math.toRadians((double)(dx + i) / (7.0 / (double)j)));
                    float[] fArray6 = noise[i];
                    int n6 = k;
                    fArray6[n6] = fArray6[n6] * (float)Fastmath.sin((double)Math.toRadians((double)(dz + k) / (5.0 / (double)j)));
                    float[] fArray7 = noise[i];
                    int n7 = k;
                    fArray7[n7] = fArray7[n7] * (float)Fastmath.sin((double)Math.toRadians((double)(dx + i) / (5.0 / (double)j)));
                    float[] fArray8 = noise[i];
                    int n8 = k;
                    fArray8[n8] = fArray8[n8] * (float)Fastmath.sin((double)Math.toRadians((double)(dz + k) / (3.0 / (double)j)));
                    float[] fArray9 = noise[i];
                    int n9 = k;
                    fArray9[n9] = fArray9[n9] * (float)Fastmath.sin((double)Math.toRadians((double)(dx + i) * (2.0 / (double)j)));
                    float[] fArray10 = noise[i];
                    int n10 = k;
                    fArray10[n10] = fArray10[n10] * (float)Fastmath.sin((double)Math.toRadians((dz + k) * (3 / j)));
                    float[] fArray11 = noise[i];
                    int n11 = k;
                    fArray11[n11] = fArray11[n11] * (float)Fastmath.sin((double)Math.toRadians((dx + i) * (3 / j)));
                    float[] fArray12 = noise[i];
                    int n12 = k;
                    fArray12[n12] = fArray12[n12] * (float)Fastmath.sin((double)Math.toRadians((dz + k) * (5 / j)));
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        i = 0;
        while (i < 16) {
            k = 0;
            while (k < 16) {
                float[] fArray = noise[i];
                int n = k++;
                fArray[n] = fArray[n] * 35.0f;
            }
            ++i;
        }
        i = 0;
        while (i < 16) {
            k = 0;
            while (k < 16) {
                double t = noise[i][k] * 2.1f + 70.0f;
                stoneheight[i][k] = (int)t;
                t = Math.abs(noise2[i][k] / 2.0f * (float)dirtamp);
                dirtheight[i][k] = (int)t;
                int[] nArray = dirtheight[i];
                int n = k;
                nArray[n] = nArray[n] + stoneheight[i][k];
                if (stoneheight[i][k] < waterlevel + 10 && stoneheight[i][k] >= waterlevel) {
                    t = Math.abs(noise2[i][k] / 2.0f * (float)dirtamp) * (((float)stoneheight[i][k] - (float)waterlevel) / 10.0f);
                    dirtheight[i][k] = (int)t;
                    int[] nArray2 = dirtheight[i];
                    int n13 = k;
                    nArray2[n13] = nArray2[n13] + stoneheight[i][k];
                }
                baseheight[i][k] = 0;
                ++k;
            }
            ++i;
        }
    }

    public void generate(World w, int d, Chunk c, int cx, int cz, int[][] dirtheight, int[][] stoneheight, int[][] bottomheight) {
        int waterlevel = 60;
        int j = 0;
        while (j < 200) {
            int i = 0;
            while (i < 16) {
                int k = 0;
                while (k < 16) {
                    if (j < stoneheight[i][k]) {
                        c.setblock(i, j, k, Blocks.stone.blockID);
                    } else if (j <= waterlevel) {
                        c.setblock(i, j, k, Blocks.waterstatic.blockID);
                        if (j == waterlevel && c.getblock(i, j - 1, k) == Blocks.stone.blockID) {
                            c.setblock(i, j - 1, k, Blocks.sand.blockID);
                        }
                    } else {
                        if (j < dirtheight[i][k] && j < 120 && c.getblock(i, j - 1, k) != Blocks.waterstatic.blockID && c.getblock(i, j - 1, k) != 0) {
                            c.setblock(i, j, k, Blocks.dirt.blockID);
                        }
                        if (j == dirtheight[i][k] && j < 100 && c.getblock(i, j - 1, k) == Blocks.dirt.blockID) {
                            c.setblock(i, j, k, Blocks.grassblock.blockID);
                            c.setblockmeta(i, j, k, w.rand.nextInt(4) << 12);
                        }
                    }
                    if (j == 0) {
                        c.setblock(i, j, k, Blocks.stopblock.blockID);
                    }
                    ++k;
                }
                ++i;
            }
            ++j;
        }
        Ores.generateConditional((World)w, (int)d, (Biome)this, (Chunk)c, (int)cx, (int)cz);
    }

    public void decorate(World world, int d, Chunk c, int chunkx, int chunkz) {
        boolean trees = this.addTrees(world, d, chunkx << 4, chunkz << 4, c);
        this.tr.addGrass(world, d, chunkx << 4, chunkz << 4, c);
        if (!trees && this.recently_added <= 0) {
            this.addBIGTrees(world, d, chunkx << 4, chunkz << 4, c);
        }
        --this.recently_added;
    }

    public boolean addTrees(World world, int d, int chunkX, int chunkZ, Chunk chunk) {
        if (world.rand.nextInt(4) != 0) {
            return false;
        }
        int howmany = 0;
        int what = world.rand.nextInt(6);
        boolean trees_added = false;
        howmany = world.rand.nextInt(10);
        if (what >= 4) {
            what = world.rand.nextInt(6);
        }
        if (what == 0) {
            howmany *= 2;
        }
        if (what >= 4) {
            howmany /= 2;
        }
        int i = 0;
        while (i < howmany) {
            int posX = chunkX + world.rand.nextInt(16);
            int posZ = chunkZ + world.rand.nextInt(16);
            int posY = 128;
            while (posY > 40) {
                if (world.getblock(d, posX, posY, posZ) == 0 && world.getblock(d, posX, posY - 1, posZ) == Blocks.grassblock.blockID) {
                    if (what == 0) {
                        this.tr.ScragglyTreeWithBranches(world, d, posX, posY, posZ);
                        trees_added = true;
                        break;
                    }
                    if (what == 1) {
                        this.tr.makeFruitTree(world, d, posX, posY - 1, posZ, Blocks.peachleaves.blockID);
                        trees_added = true;
                        break;
                    }
                    if (what == 2) {
                        this.tr.makeFruitTree(world, d, posX, posY - 1, posZ, Blocks.cherryleaves.blockID);
                        trees_added = true;
                        break;
                    }
                    if (what == 3) {
                        this.tr.makeFruitTree(world, d, posX, posY - 1, posZ, Blocks.appleleaves.blockID);
                        trees_added = true;
                        break;
                    }
                    if (what == 4) {
                        this.otr.SkyTree(world, d, posX, posY - 1, posZ);
                        trees_added = true;
                        this.recently_added += 5;
                        break;
                    }
                    if (what != 5) break;
                    this.otr.WindTree(world, d, posX, posY - 1, posZ, 0);
                    trees_added = true;
                    this.recently_added += 5;
                    break;
                }
                --posY;
            }
            ++i;
        }
        return trees_added;
    }

    public void addBIGTrees(World world, int d, int chunkX, int chunkZ, Chunk chunk) {
        if (world.rand.nextInt(50) != 0) {
            return;
        }
        int x = 4 + chunkX + world.rand.nextInt(12);
        int z = 4 + chunkZ + world.rand.nextInt(12);
        int y = 128;
        while (y > 40) {
            if (world.getblock(d, x, y + 1, z) == 0 && world.getblock(d, x, y, z) == Blocks.grassblock.blockID) {
                int rand_treetype;
                this.recently_added = 100;
                int tree_radius = 6;
                boolean no_critters = true;
                int tmp = world.rand.nextInt(3);
                int leaf_type = Blocks.leaves.blockID;
                int wood_id = Blocks.log.blockID;
                if (tmp == 1) {
                    wood_id = Blocks.willowlog.blockID;
                }
                if (tmp == 2) {
                    wood_id = Blocks.redwoodlog.blockID;
                }
                if ((tmp = world.rand.nextInt(3)) == 1) {
                    leaf_type = Blocks.willowleaves.blockID;
                }
                if (tmp == 2) {
                    leaf_type = Blocks.redwoodleaves.blockID;
                }
                if (world.rand.nextInt(4) == 1) {
                    no_critters = false;
                }
                if ((rand_treetype = world.rand.nextInt(100)) >= 10) {
                    if (rand_treetype >= 40) {
                        if (world.rand.nextInt(10) == 1) {
                            leaf_type = Blocks.appleleaves.blockID;
                        }
                        this.otr.MakeBigSquareTree(world, d, x, y, z, wood_id, leaf_type, Blocks.greystone.blockID, tree_radius, no_critters);
                    } else {
                        this.otr.MakeBigCircularTree(world, d, x, y, z, wood_id, leaf_type, Blocks.greystone.blockID, tree_radius, no_critters);
                    }
                } else if (rand_treetype == 1) {
                    if (world.rand.nextInt(2) == 1) {
                        this.otr.MakeBigSquareTree(world, d, x, y, z, Blocks.blocksunstone.blockID, OreSpawnMain.blockruby.blockID, Blocks.blockdiamond.blockID, tree_radius, no_critters);
                    } else {
                        this.otr.MakeBigSquareTree(world, d, x, y, z, Blocks.blockplatinum.blockID, Blocks.blockemerald.blockID, Blocks.blocklight.blockID, tree_radius, no_critters);
                    }
                } else {
                    this.otr.MakeBigRoundTree(world, d, x, y, z, wood_id, leaf_type, tree_radius);
                }
                return;
            }
            --y;
        }
    }

    public boolean canOreBeHere(World w, int oreID, int d, Biome b, int cx, int cz) {
        if (oreID == Blocks.orelight.blockID) {
            return true;
        }
        if (oreID == Blocks.oredark.blockID) {
            return true;
        }
        if (oreID == Blocks.orecopper.blockID) {
            return true;
        }
        if (oreID == Blocks.oretin.blockID) {
            return true;
        }
        if (oreID == Blocks.oresilver.blockID) {
            return true;
        }
        if (oreID == Blocks.oreemerald.blockID) {
            return true;
        }
        if (oreID == OreSpawnMain.oreruby.blockID) {
            return true;
        }
        return oreID == OreSpawnMain.oreamethyst.blockID;
    }
}

